% This file generates figures for the Nikon D100
close all; clear all; clc;

% Get the data file
load ncones.mat

% Transpose the wavelength
wavelength = wavelength.';

% Get the colors
red_wl = nearest( sum(data(:,1) .* wavelength) / sum(data(:,1)));
green_wl = nearest( sum(data(:,2) .* wavelength) / sum(data(:,2)));
blue_wl = nearest( sum(data(:,3) .* wavelength) / sum(data(:,3)));
[r_r,r_g,r_b] = WavelengthToRGB(red_wl);
[g_r,g_g,g_b] = WavelengthToRGB(green_wl);
[b_r,b_g,b_b] = WavelengthToRGB(blue_wl);

% Plot the filter spectra
figure(1);
plot(wavelength, data(:,1), 'LineWidth', 2,  'Color', [r_r r_g r_b]);
hold on;
plot(wavelength, data(:,2), 'LineWidth', 2,  'Color', [g_r g_g g_b]);
plot(wavelength, data(:,3), 'LineWidth', 2,  'Color', [b_r b_g b_b]);
plot(wavelength, sum(data,2), 'k--', 'LineWidth', 2);
xlabel('Wavelength (nm)');
ylabel('Normalized Cone Sensitivity');
title('Smith-Pokorny Cones (Normalized)');
xlim([380 710]);
ylim([0 1.1*max(sum(data,2))]);
grid on;
saveas(gcf, 'Eye_Spectra.eps', 'epsc2');

% End of File
